/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class VWSIMProductionArrivalPanel
extends VWSIMArrivalPanel
implements ActionListener,
DocumentListener {
    private VWToolbarBorder m_acquireStartTimeBorder = null;
    private JLabel m_acquireStartDateLabel = null;
    private JTextField m_acquireStartDateTextField = null;
    private JLabel m_acquireStartTimeLabel = null;
    private JTextField m_acquireStartTimeTextField = null;
    private JButton m_acquireStartCalendarButton = null;
    private VWToolbarBorder m_acquireEndTimeBorder = null;
    private JLabel m_acquireEndDateLabel = null;
    private JTextField m_acquireEndDateTextField = null;
    private JLabel m_acquireEndTimeLabel = null;
    private JTextField m_acquireEndTimeTextField = null;
    private JButton m_acquireEndCalendarButton = null;
    private VWToolbarBorder m_startTimeBorder = null;
    private JRadioButton m_sameStartTimeRadioButton = null;
    private JRadioButton m_startDateRadioButton = null;
    private JTextField m_startDateTextField = null;
    private JLabel m_startTimeLabel = null;
    private JTextField m_startTimeTextField = null;
    private JButton m_startCalendarButton = null;
    private VWToolbarBorder m_adjustFactorBorder = null;
    private VWNumericTextField m_adjustFactorTextField = null;
    private GridBagConstraints m_gridCons = null;
    private VWScenarioArrivalPattern m_arrivalPattern = null;
    private VWSIMPropertyData m_propertyData = null;

    public VWSIMProductionArrivalPanel(VWSIMPropertyData propertyData) {
        super(propertyData);
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gridCons = new GridBagConstraints();
        this.initAcquireStartTimeControls();
        this.initAcquireEndTimeControls();
        this.initStartTimeControls();
        this.initAdjustFactorControls();
    }

    public void enablePropertyPanel(boolean enable) {
        this.m_sameStartTimeRadioButton.setEnabled(enable);
        this.m_startDateRadioButton.setEnabled(enable);
        this.m_startDateTextField.setEnabled(enable);
        this.m_startTimeTextField.setEnabled(enable);
        this.m_startCalendarButton.setEnabled(enable);
        this.m_acquireStartTimeBorder.setEnabled(enable);
        this.m_acquireStartDateTextField.setEnabled(enable);
        this.m_acquireStartTimeTextField.setEnabled(enable);
        this.m_acquireStartCalendarButton.setEnabled(enable);
        this.m_acquireEndDateTextField.setEnabled(enable);
        this.m_acquireEndTimeTextField.setEnabled(enable);
        this.m_acquireEndCalendarButton.setEnabled(enable);
        this.m_adjustFactorTextField.setEnabled(enable);
    }

    public void setArrivalPattern(VWSIMPropertyData propertyData, VWScenarioArrivalPattern arrivalPattern) {
        this.m_propertyData = propertyData;
        this.m_arrivalPattern = arrivalPattern;
        this.reinitialize();
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_sameStartTimeRadioButton) {
            this.performSameStartTimeRadioButton();
        } else if (src == this.m_startDateRadioButton) {
            this.performStartDateRadioButton();
        } else if (src == this.m_startCalendarButton) {
            this.performStartCalendarButtonAction();
        } else if (src == this.m_acquireStartCalendarButton) {
            this.performAcquireStartCalendarButtonAction();
        } else if (src == this.m_acquireEndCalendarButton) {
            this.performAcquireEndCalendarButtonAction();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_adjustFactorTextField.getDocument()) {
            this.updateAdjustFactorTextField();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void initStartTimeControls() {
        try {
            this.m_startTimeBorder = new VWToolbarBorder(VWSIMResource.s_startDateTime);
            JPanel clientPanel = this.m_startTimeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 5;
            gbCons.gridheight = 1;
            this.m_sameStartTimeRadioButton = new JRadioButton(VWSIMResource.s_sameAsScenarioStartTime);
            this.m_sameStartTimeRadioButton.setEnabled(false);
            this.m_sameStartTimeRadioButton.setSelected(true);
            this.m_sameStartTimeRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_sameStartTimeRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(-5, 0, 0, 0);
            this.m_startDateRadioButton = new JRadioButton(VWSIMResource.s_date);
            this.m_startDateRadioButton.setEnabled(false);
            this.m_startDateRadioButton.setSelected(false);
            this.m_startDateRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_startDateRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_startDateTextField = new JTextField();
            this.m_startDateTextField.setEnabled(false);
            this.m_startDateTextField.setEditable(false);
            clientPanel.add((Component)this.m_startDateTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_startTimeLabel = new JLabel(VWSIMResource.s_time);
            clientPanel.add((Component)this.m_startTimeLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_startTimeTextField = new JTextField();
            this.m_startTimeTextField.setEnabled(false);
            this.m_startTimeTextField.setEditable(false);
            clientPanel.add((Component)this.m_startTimeTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_startCalendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_startCalendarButton.setEnabled(false);
            this.m_startCalendarButton.addActionListener(this);
            clientPanel.add((Component)this.m_startCalendarButton, gbCons);
            buttonGroup.add(this.m_sameStartTimeRadioButton);
            buttonGroup.add(this.m_startDateRadioButton);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 3;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 0.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_startTimeBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initAcquireStartTimeControls() {
        try {
            this.m_acquireStartTimeBorder = new VWToolbarBorder(VWSIMResource.s_acquireStartDateTime);
            JPanel clientPanel = this.m_acquireStartTimeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 0, 0, 0);
            this.m_acquireStartDateLabel = new JLabel(VWSIMResource.s_date);
            clientPanel.add((Component)this.m_acquireStartDateLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(3, 3, 0, 0);
            this.m_acquireStartDateTextField = new JTextField();
            this.m_acquireStartDateTextField.setEnabled(false);
            this.m_acquireStartDateTextField.setEditable(false);
            clientPanel.add((Component)this.m_acquireStartDateTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(3, 5, 0, 0);
            this.m_acquireStartTimeLabel = new JLabel(VWSIMResource.s_time);
            clientPanel.add((Component)this.m_acquireStartTimeLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(3, 3, 0, 0);
            this.m_acquireStartTimeTextField = new JTextField();
            this.m_acquireStartTimeTextField.setEnabled(false);
            this.m_acquireStartTimeTextField.setEditable(false);
            clientPanel.add((Component)this.m_acquireStartTimeTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_acquireStartCalendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_acquireStartCalendarButton.setEnabled(false);
            this.m_acquireStartCalendarButton.addActionListener(this);
            clientPanel.add((Component)this.m_acquireStartCalendarButton, gbCons);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 1;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 0.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_acquireStartTimeBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initAcquireEndTimeControls() {
        try {
            this.m_acquireEndTimeBorder = new VWToolbarBorder(VWSIMResource.s_acquireEndDateTime);
            JPanel clientPanel = this.m_acquireEndTimeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 0, 0, 0);
            this.m_acquireEndDateLabel = new JLabel(VWSIMResource.s_date);
            clientPanel.add((Component)this.m_acquireEndDateLabel, gbCons);
            gbCons.gridx = 1;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 0, 0);
            this.m_acquireEndDateTextField = new JTextField();
            this.m_acquireEndDateTextField.setEnabled(false);
            this.m_acquireEndDateTextField.setEditable(false);
            clientPanel.add((Component)this.m_acquireEndDateTextField, gbCons);
            gbCons.gridx = 2;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 5, 0, 0);
            this.m_acquireEndTimeLabel = new JLabel(VWSIMResource.s_time);
            clientPanel.add((Component)this.m_acquireEndTimeLabel, gbCons);
            gbCons.gridx = 3;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 0, 0);
            this.m_acquireEndTimeTextField = new JTextField();
            this.m_acquireEndTimeTextField.setEnabled(false);
            this.m_acquireEndTimeTextField.setEditable(false);
            clientPanel.add((Component)this.m_acquireEndTimeTextField, gbCons);
            gbCons.gridx = 4;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 0, 0);
            this.m_acquireEndCalendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_acquireEndCalendarButton.setEnabled(false);
            this.m_acquireEndCalendarButton.addActionListener(this);
            clientPanel.add((Component)this.m_acquireEndCalendarButton, gbCons);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 2;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 0.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_acquireEndTimeBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initAdjustFactorControls() {
        try {
            this.m_adjustFactorBorder = new VWToolbarBorder(VWSIMResource.s_adjustFactor);
            JPanel clientPanel = this.m_adjustFactorBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_adjustFactorTextField = new VWNumericTextField(6, 2, true);
            this.m_adjustFactorTextField.setEnabled(false);
            this.m_adjustFactorTextField.getDocument().addDocumentListener(this);
            clientPanel.add(this.m_adjustFactorTextField);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 4;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 1.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_adjustFactorBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        try {
            if (this.m_arrivalPattern != null) {
                Object startDateTime = this.m_arrivalPattern.getStartTime();
                Date acquireStartDateTime = this.m_arrivalPattern.getAcquireStartTime();
                Object acquireEndDateTime = this.m_arrivalPattern.getAcquireEndTime();
                float adjustFactor = this.m_arrivalPattern.getAdjustFactor();
                if (startDateTime != null) {
                    if (startDateTime instanceof VWScenarioTimeDuration) {
                        this.m_sameStartTimeRadioButton.removeActionListener(this);
                        this.m_sameStartTimeRadioButton.setSelected(true);
                        this.m_sameStartTimeRadioButton.addActionListener(this);
                        this.m_startDateTextField.setText("");
                        this.m_startDateTextField.setEnabled(false);
                        this.m_startTimeTextField.setText("");
                        this.m_startTimeTextField.setEnabled(false);
                        this.m_startCalendarButton.setEnabled(false);
                    } else if (startDateTime instanceof Date) {
                        Date startDateTimeObj = (Date)startDateTime;
                        this.m_startDateTextField.setText(VWDateTimeFormat.getDateString(startDateTimeObj));
                        this.m_startTimeTextField.setText(VWDateTimeFormat.getTimeString(startDateTimeObj));
                        this.m_startDateRadioButton.removeActionListener(this);
                        this.m_startDateRadioButton.setSelected(true);
                        this.m_startDateRadioButton.addActionListener(this);
                        this.m_startDateTextField.setEnabled(true);
                        this.m_startTimeTextField.setEnabled(true);
                        this.m_startCalendarButton.setEnabled(true);
                    }
                }
                if (acquireStartDateTime != null) {
                    this.m_acquireStartDateTextField.setText(VWDateTimeFormat.getDateString(acquireStartDateTime));
                    this.m_acquireStartTimeTextField.setText(VWDateTimeFormat.getTimeString(acquireStartDateTime));
                }
                if (acquireEndDateTime != null) {
                    if (acquireEndDateTime instanceof Date) {
                        Date endDateTime = (Date)acquireEndDateTime;
                        this.m_acquireEndDateTextField.setText(VWDateTimeFormat.getDateString(endDateTime));
                        this.m_acquireEndTimeTextField.setText(VWDateTimeFormat.getTimeString(endDateTime));
                        this.m_acquireEndDateTextField.setEnabled(true);
                        this.m_acquireEndTimeTextField.setEnabled(true);
                        this.m_acquireEndCalendarButton.setEnabled(true);
                    } else if (acquireEndDateTime instanceof VWScenarioTimeDuration) {
                        this.m_acquireEndDateTextField.setText("");
                        this.m_acquireEndDateTextField.setEnabled(false);
                        this.m_acquireEndTimeTextField.setEnabled(false);
                        this.m_acquireEndTimeTextField.setText("");
                        this.m_acquireEndCalendarButton.setEnabled(false);
                    }
                    this.m_adjustFactorTextField.getDocument().removeDocumentListener(this);
                    this.m_adjustFactorTextField.setText(adjustFactor + "");
                    this.m_adjustFactorTextField.getDocument().addDocumentListener(this);
                }
            } else {
                this.m_startDateTextField.setText("");
                this.m_startTimeTextField.setText("");
                this.m_acquireStartDateTextField.setText("");
                this.m_acquireStartTimeTextField.setText("");
                this.m_acquireEndDateTextField.setText("");
                this.m_acquireEndTimeTextField.setText("");
                this.m_adjustFactorTextField.getDocument().removeDocumentListener(this);
                this.m_adjustFactorTextField.setText("");
                this.m_adjustFactorTextField.getDocument().addDocumentListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performStartCalendarButtonAction() {
        try {
            String initDateString = this.m_startDateTextField.getText();
            String initTimeString = this.m_startTimeTextField.getText();
            VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
            calendarDlg.setVisible(true);
            if (calendarDlg.getCloseStatus() == 1) {
                Date date = calendarDlg.getDate();
                String dateString = VWDateTimeFormat.getDateString(date);
                String timeString = VWDateTimeFormat.getTimeString(date);
                this.m_startDateTextField.setText(dateString);
                this.m_startTimeTextField.setText(timeString);
                this.m_arrivalPattern.setStartTime(date);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAcquireStartCalendarButtonAction() {
        try {
            String initDateString = this.m_acquireStartDateTextField.getText();
            String initTimeString = this.m_acquireStartTimeTextField.getText();
            VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
            calendarDlg.setVisible(true);
            if (calendarDlg.getCloseStatus() == 1) {
                Date date = calendarDlg.getDate();
                String dateString = VWDateTimeFormat.getDateString(date);
                String timeString = VWDateTimeFormat.getTimeString(date);
                this.m_acquireStartDateTextField.setText(dateString);
                this.m_acquireStartTimeTextField.setText(timeString);
                this.m_arrivalPattern.setAcquireStartTime(date);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAcquireEndCalendarButtonAction() {
        try {
            String initDateString = this.m_acquireEndDateTextField.getText();
            String initTimeString = this.m_acquireEndTimeTextField.getText();
            VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
            calendarDlg.setVisible(true);
            if (calendarDlg.getCloseStatus() == 1) {
                Date date = calendarDlg.getDate();
                String dateString = VWDateTimeFormat.getDateString(date);
                String timeString = VWDateTimeFormat.getTimeString(date);
                this.m_acquireEndDateTextField.setText(dateString);
                this.m_acquireEndTimeTextField.setText(timeString);
                this.m_arrivalPattern.setAcquireEndTime(date);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateAcquireEndDurationTextField() {
    }

    private void performSameStartTimeRadioButton() {
        try {
            this.m_startDateTextField.setText("");
            this.m_startDateTextField.setEnabled(false);
            this.m_startTimeTextField.setText("");
            this.m_startTimeTextField.setEnabled(false);
            this.m_startCalendarButton.setEnabled(false);
            if (this.m_arrivalPattern != null) {
                VWScenarioTimeDuration startDuration = new VWScenarioTimeDuration("0", 3);
                this.m_arrivalPattern.setStartTime(startDuration);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performStartDateRadioButton() {
        try {
            this.m_startTimeTextField.setEnabled(true);
            this.m_startDateTextField.setEnabled(true);
            this.m_startCalendarButton.setEnabled(true);
            Date startDateTime = (Date)this.m_propertyData.getScenarioDefinition().getStartTime();
            this.m_arrivalPattern.setStartTime(startDateTime);
            this.m_propertyData.setDirty();
            String dateString = VWDateTimeFormat.getDateString(startDateTime);
            String timeString = VWDateTimeFormat.getTimeString(startDateTime);
            this.m_startDateTextField.setText(dateString);
            this.m_startTimeTextField.setText(timeString);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAcquireEndDateTimeRadioButton() {
        try {
            this.m_acquireEndTimeTextField.setEnabled(true);
            this.m_acquireEndDateTextField.setEnabled(true);
            this.m_acquireEndCalendarButton.setEnabled(true);
            Date endDateTime = new Date();
            this.m_arrivalPattern.setAcquireEndTime(endDateTime);
            this.m_propertyData.setDirty();
            String dateString = VWDateTimeFormat.getDateString(endDateTime);
            String timeString = VWDateTimeFormat.getTimeString(endDateTime);
            this.m_acquireEndDateTextField.setText(dateString);
            this.m_acquireEndTimeTextField.setText(timeString);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAcquireEndDurationRadioButton() {
        try {
            this.m_acquireEndTimeTextField.setText("");
            this.m_acquireEndTimeTextField.setEnabled(false);
            this.m_acquireEndDateTextField.setText("");
            this.m_acquireEndDateTextField.setEnabled(false);
            this.m_acquireEndCalendarButton.setEnabled(false);
            VWScenarioTimeDuration duration = new VWScenarioTimeDuration("0", 3);
            this.m_arrivalPattern.setAcquireEndTime(duration);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAcquireEndDurationComboBox() {
    }

    private void updateAdjustFactorTextField() {
        try {
            Float value = null;
            try {
                value = new Float(this.m_adjustFactorTextField.getText());
            }
            catch (Exception ex) {
                value = new Float(0.0f);
            }
            this.m_arrivalPattern.setAdjustFactor(value.floatValue());
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

